<?php
session_start();
require_once "../../../controladores/caja.controlador.php";
require_once "../../../modelos/caja.modelo.php";

require_once "../../../controladores/plantilla.controlador.php";
require_once "../../../modelos/configuracion.modelo.php";


// require_once "../../../controladores/productos.controlador.php";
// require_once "../../../modelos/productos.modelo.php";

class imprimirEstadoServicio{

public $idUsuario;

public function traerImpresionEstadoServicio(){

	date_default_timezone_set("America/Mexico_City");
    setlocale(LC_ALL, 'spanish');

//TRAEMOS LA INFORMACIÓN DE LA VENTA
$plantilla = new ControladorPlantilla();
$configuracion = $plantilla -> ctrConfiguracion()[0];
$logo = $configuracion['logo'];
$razon_social = $configuracion['razon_social'];
$prefijo =  $configuracion['prefijo'];
$celular =  $configuracion['celular'];
$email =  $configuracion['email'];
$direccion =  $configuracion['direccion'];
$nombreEmpresa = "$razon_social <br>Celular: $prefijo $celular <br> Correo: $email <br> Dirección: $direccion";

$idusuario = $this->idUsuario;
$fecha1 = null;
$fecha2 = null;
if(isset($_GET['fecha1']))
	$fecha1 = $_GET['fecha1'];
if(isset($_GET['fecha2']))
	$fecha2 = $_GET['fecha2'];

$idUsuario = $_SESSION['id'];   
if($_SESSION["perfil"] == "Administrador")
	$datosCaja = ControladorCaja::ctrMostrarDetalleCajaMovimiento(null,  $fecha1, $fecha2);
else
	$datosCaja = ControladorCaja::ctrMostrarDetalleCajaMovimiento($idUsuario,  $fecha1, $fecha2);

//REQUERIMOS LA CLASE TCPDF
if(count($datosCaja) == 0){
	echo "El usuario no presenta registros vuelva a intertarlo mas tarde o verifique que la fecha coinsida con las tablas registras";
	echo "<br>";
	echo "Fecha inicio filtro: ".$fecha1."<br>";
	echo "Fecha fin filtro: ".$fecha2;
	exit;
}

require_once('tcpdf_include.php');

$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

$pdf->startPageGroup();

//$pdf->AddPage();
$pdf->AddPage('L');

// ---------------------------------------------------------

$bloque1 = <<<EOF

	<table>

	<tr>

	<td style="width:200px">
	<div>
	<br>
	<img src="../../../$logo" style="width: 140px;">
	</div>
	</td>

	<td style="width:580px">

	<div style="font-size:8.5px; text-align:right; line-height:15px;">
		<br>
		$nombreEmpresa

		</div>

	</td>

</tr>

	</table>

EOF;

$pdf->writeHTML($bloque1, false, false, false, false, '');



//se modificaron las columnas

$bloque3 = <<<EOF

	<table style="font-size:9px; padding:5px 10px;">

		<tr>
		<br>
		<br>

		<td style="border: 1px solid #666666; background-color:white; width:60px; text-align:center"><b>#.</b></td>
		<td style="border: 1px solid #666666; background-color:white; width:150px; text-align:center"><b>Nombres</b></td>

		<td style="border: 1px solid #666666; background-color:white; width:80px; text-align:center"><b>Tipo caja</b></td>

		<td style="border: 1px solid #666666; background-color:white; width:170px; text-align:center"><b>Concepto</b></td>

		<td style="border: 1px solid #666666; background-color:white; width:80px; text-align:center"><b>Numero Documento</b></td>

		<td style="border: 1px solid #666666; background-color:white; width:80px; text-align:center"><b>importe</b></td>
		<td style="border: 1px solid #666666; background-color:white; width:80px; text-align:center"><b>Tipo de pago</b></td>
		<td style="border: 1px solid #666666; background-color:white; width:80px; text-align:center"><b>Estado</b></td>
		</tr>

	</table>

EOF;

$pdf->writeHTML($bloque3, false, false, false, false, '');

// -------------------------------------------------

// Aqui  hace el ciclo para agregar las filas
foreach ($datosCaja as $key => $value) {
$importe = number_format($value["importeCaja"],2,'.',',');
$bloque4 = <<<EOF

 	<table style="font-size:10px; padding:5px 10px;">

 		<tr>
 			<td style="border: 1px solid #666666; color:#333; background-color:white; width:60px; text-align:center"><b>
 				$value[id]</b>
 			</td>

			 <td style="border: 1px solid #666666; color:#333; background-color:white; width:150px; text-align:center"><b>
 				$value[nombre]</b>
 			</td>

 			<td style="border: 1px solid #666666; color:#333; background-color:white; width:80px; text-align:center">
 				$value[tipoCaja]
 			</td>

 			<td style="border: 1px solid #666666; color:#333; background-color:white; width:170px; text-align:center">
 				$value[concepto]
 			</td>

 			<td style="border: 1px solid #666666; color:#333; background-color:white; width:80px; text-align:center">$value[numeroDocumento]
 			</td>

 			<td style="border: 1px solid #666666; color:#333; background-color:white; width:80px; text-align:center">
			 $importe
 			</td>
 			<td style="border: 1px solid #666666; color:#333; background-color:white; width:80px; text-align:center">
			 $value[tipoPago]
 			</td>

 			<td style="border: 1px solid #666666; color:#333; background-color:white; width:80px; text-align:center">Pagado
 			</td>
			


 		</tr>

 	</table>


EOF;

	$pdf->writeHTML($bloque4, false, false, false, false, '');

}


//SALIDA DEL ARCHIVO

//$pdf->Output('factura.pdf', 'D');
$pdf->Output('Estado_Cuenta.pdf');

}

}

$reporte = new imprimirEstadoServicio();
$reporte -> idUsuario = base64_decode($_GET["idcaja"]);
//echo base64_decode($_GET["idcaja"]);
$reporte -> traerImpresionEstadoServicio();

?>
